﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Linq___1
{


    class Program
    {
        static void Main(string[] args)
        {
            List<Student> studenti = new List<Student>();

            StreamReader sr = new StreamReader("studenti.csv");

            sr.ReadLine();

            string linija;
            string[] kolone;
            while (!sr.EndOfStream)
            {
                linija = sr.ReadLine();

                kolone = linija.Split(',');

                int godina = int.Parse(kolone[0]);
                string ime = kolone[1];
                int indeks = int.Parse(kolone[2]);
                string mesto = kolone[3];

                Student s = new Student { godina = godina, ime = ime, indeks = indeks, mesto = mesto};
                studenti.Add(s);

                //Console.WriteLine(linija);
            }

            foreach (var s in studenti)
            {
                //Console.WriteLine(s.ime);
            }

            //IEnumerable<string> imena = studenti.Select(st => st.ime);

            //var rezultat = from st in studenti
            //               select new { NovoIme = st.ime,  novaGodina = st.godina};

            IEnumerable<Klasa1> rezultat = studenti.Select(st => new Klasa1 (st.godina, st.ime));

            foreach (var red in rezultat)
            {
                //Console.WriteLine(red.ime + ", " + red.godina);
            }

            //Console.WriteLine(studenti.Select(s => s.mesto).Distinct().Count());

            foreach (var m in studenti.Select(s => s.mesto))
            {
                //Console.WriteLine(m);
            }

            int brojMesta = (from s in studenti
                             where s.mesto.Trim().Equals("Kragujevac")
                             select s).Count();

            //Console.WriteLine(brojMesta);


            foreach (var s in studenti.OrderBy(s => s.godina).ThenBy( s => s.indeks))
            {
                //Console.WriteLine(s);
            }


             var grupisaniStudenti = from student in studenti
                                     group student by student.mesto.Trim() into grupa
                                     select new { kljuc = grupa.Key, brojStudenata = grupa.Count() };

            foreach (var grupa in grupisaniStudenti)
            {
                //Console.WriteLine(grupa.kljuc + ", " + grupa.brojStudenata);
            }

            /*foreach (var grupa in grupisaniStudenti)
            {
                Console.WriteLine(grupa.Key + ", " + grupa.Count());


                foreach (var student in grupa)
                {
                    Console.WriteLine("\t " + student.ime);
                }
            }*/



            StudijeDataContext studijeDC = new StudijeDataContext();


            var rez = from s in studijeDC.Studentis
                          join p in studijeDC.Prijaves.Where(p => p.Ocena > 5)
                          on new { s.Indeks, s.Upisan } equals new { Indeks = p.Indeks.Value, Upisan = p.Upisan.Value } into grupaPrijava
                          select new { s.Indeks, s.Upisan, s.Imes, brojIspita = grupaPrijava.Count(), prosek = grupaPrijava.Average( p=>p.Ocena * 1.0),   ispiti = grupaPrijava };

            foreach (var r in rez)
            {
                Console.WriteLine(r.Imes + " : " + r.brojIspita + ", " + r.prosek);

                foreach (var i in r.ispiti)
                {
                    Console.WriteLine(i.Ocena);
                }
            }
        }
        public class Klasa1
        {
            public int godina;
            public string ime;

            public Klasa1(int godina, string ime)
            {
                this.godina = godina;
                this.ime = ime;
            }
        }
    }
}
